package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class PatientDataCollection<T extends PatientData> extends DomainTransferObjectCollection<T> {
	private static final long serialVersionUID = 1L;
	private PatientIdentifier patientIdentifier;

	public List<PatientData> getPatientDataList() {
		List<PatientData> list = new ArrayList<PatientData>();
		for (PatientData data : this) {
			list.add(data);
		}
		return list;
	}

	public PatientIdentifier getPatientIdentifier() {
		if (patientIdentifier == null)
			this.patientIdentifier = new PatientIdentifier();
		return patientIdentifier;
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
	}

	public void updatePatientIdentifier(PatientIdentifier patientIdentifier) {
		this.setPatientIdentifier(patientIdentifier);
		for (PatientData data : this) {
			data.setPatientIdentifier(patientIdentifier);
		}
	}

	public void updateSystemId(String systemId) {
		for (PatientData data : this) {
			data.getDataIdentifier().setSystemId(systemId);
		}
	}

	public T findMatchById(DataIdentifier id) {
		T match = null;
		for (T potentialMatch : this) {
			if (potentialMatch.getDataIdentifier().equals(id))
				match = potentialMatch;
		}
		return match;
	}

	public T findMatchById(T patientData) {
		return findMatchById(patientData.getDataIdentifier());
	}

	public void logData(org.apache.commons.logging.Log logger) {
		logger.debug(String.format("debug log of patient data collection [object=%s][size=%s]", this.toString(), this.size()));
		for (T o : this) {
			o.logData(logger);
		}
	}

}
