package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;

public class PatientData extends DomainTransferObject {
	private static final long serialVersionUID = 1L;

	@XmlAttribute
	private String sourceSystem;

	@XmlElement
	private DataIdentifier dataIdentifier;

	@XmlElement
	private PatientIdentifier patientIdentifier;

    @XmlElement
    private PatientIdentifier surrogateIdentifier;         //Identifier for person acting on behalf of the patient

    public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public PatientIdentifier getPatientIdentifier() {
		if (patientIdentifier == null)
			patientIdentifier = new PatientIdentifier();
		return patientIdentifier;
	}

    public PatientIdentifier getSurrogateIdentifier() {
        if (surrogateIdentifier == null)
            surrogateIdentifier = new PatientIdentifier();
        return surrogateIdentifier;
    }

    public void setSurrogateIdentifier(PatientIdentifier surrogateIdentifier) {
        this.surrogateIdentifier = surrogateIdentifier;
    }

    public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setPatientId(String patientId) {
		getPatientIdentifier().setUniqueId(patientId);
	}
	
	public String getAssigningAuthority() {
		return getPatientIdentifier().getAssigningAuthority();
	}
	
	public void setAssigningAuthority(String assigningAuthority) {
		getPatientIdentifier().setAssigningAuthority(assigningAuthority);
	}

	public void setUniqueId(String uniqueId) {
		getDataIdentifier().setUniqueId(uniqueId);
	}

	public String getUniqueId() {
		return getDataIdentifier().getUniqueId();
	}
	
	public void setSystemId(String systemId) {
		getDataIdentifier().setSystemId(systemId);
	}
	
	public String getSystemId() {
		return getDataIdentifier().getSystemId();
	}

    public String getSurrogateId() {
        return getSurrogateIdentifier().getUniqueId();
    }

	public void setDataIdentifier(DataIdentifier dataIdentifier) {
		this.dataIdentifier = dataIdentifier;
	}

	public DataIdentifier getDataIdentifier() {
		if (dataIdentifier == null){
	        dataIdentifier = new DataIdentifier();
		}
		return dataIdentifier;
	}

	public String getSourceSystem() {
		return sourceSystem;
	}

	public void setSourceSystem(String sourceSystem) {
		this.sourceSystem = sourceSystem;
	}

	public void logData(org.apache.commons.logging.Log logger) {
		logger.debug(String.format("debug log of DTO [object=%s][id=%s]", this.toString(), this.dataIdentifier));
	}

	public void setDataIdentifier(String communityId, String uniqueId) {
		getDataIdentifier().setSystemId(communityId);
		getDataIdentifier().setUniqueId(uniqueId);
	}

	public void setPatientIdentifier(String assigningAuthority, String localPatientId) {
		getPatientIdentifier().setAssigningAuthority(assigningAuthority);
		getPatientIdentifier().setUniqueId(localPatientId);
	}

    public void setSurrogateIdentifier(String assigningAuthority, String surrogateId) {
        getSurrogateIdentifier().setAssigningAuthority(assigningAuthority);
        getSurrogateIdentifier().setUniqueId(surrogateId);
    }

    @Override
	public boolean equals(Object other) {
		if(!(other instanceof PatientData)) {
			return false;
		}
		PatientData otherPatientData = (PatientData) other;
		if(otherPatientData.getUniqueId() != null) {
			return otherPatientData.getUniqueId().equals(getUniqueId());
		} else {
			return super.equals(otherPatientData);
		}
	}
	
	@Override
	public int hashCode() {
		int result = 17;
		result = 31 * result + (sourceSystem == null ? 0 : sourceSystem.hashCode());
		result = 31 * result + (dataIdentifier == null ? 0 : dataIdentifier.hashCode());
		result = 31 * result + (patientIdentifier == null ? 0 : patientIdentifier.hashCode());
        result = 31 * result + (surrogateIdentifier == null ? 0 : surrogateIdentifier.hashCode());
        return result;
	}
}
