package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.mobilehealthplatform.domain.sorting.PatientSortingAlgorithm;
import com.agilex.healthcare.utility.DOBDateMarshaller;
import com.agilex.healthcare.utility.NullChecker;

/**
 * 
 * @author j.ray
 */
@XmlRootElement(name = "patient", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Patient extends DomainTransferObject implements Comparable<Patient> {

	private static final long serialVersionUID = -3040524557861665627L;

	private String displayName = null;
	@XmlElement
	private String firstName;
	@XmlElement
	private String lastName;
	@XmlElement
	private String middleName;
	@XmlElement
	@XmlJavaTypeAdapter(DOBDateMarshaller.class)
	private DOBDate dateOfBirth;
	@XmlElement
	private String gender;
	@XmlElement
	private PatientIdentifier patientIdentifier = new PatientIdentifier();
	@XmlElement
	private String ssn;
	@XmlElement
	private String middleInitial;
	@XmlElement
	private String age = null;
	@XmlElement
	private String wardLocation = null;
	@XmlElement
	private String roombed = null;
	@XmlElement
	private String enterpriseId;
	@XmlElement
	private boolean inpatient;
	@XmlElement
	private boolean textMessagingAllowed;
	@XmlElement
	private String textMessagingPhoneNumber;

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getSsn() {
		return this.ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public DOBDate getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(DOBDate dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	@XmlTransient
	public URI getDemographicsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientDemographics);
		return AtomLink.extractUri(link);
	}

	public void setDemographicsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientDemographics);
		getLink().setLinkByTitle(link);
	}

	public String getId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setId(String id) {
		getPatientIdentifier().setUniqueId(id);
	}

	public String getWardLocation() {
		return wardLocation;
	}

	public void setWardLocation(String wardLocation) {
		this.wardLocation = wardLocation;
	}

	public String getRoombed() {
		return roombed;
	}

	public void setRoombed(String roombed) {
		this.roombed = roombed;
	}

	@XmlTransient
	public URI getDocumentsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientDocuments);
		return AtomLink.extractUri(link);
	}

	public void setDocumentsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientDocuments);
		getLink().setLinkByTitle(link);
	}

	public URI getPatientImageUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientImage);
		return AtomLink.extractUri(link);
	}

	public void setPatientImageUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientImage);
		getLink().setLinkByTitle(link);
	}

	public URI getProblemsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientProblems);
		return AtomLink.extractUri(link);
	}

	public void setProblemsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientProblems);
		getLink().setLinkByTitle(link);
	}

	public void setOutpatientProblemsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientOutpatientProblems);
		getLink().setLinkByTitle(link);
	}

	public void setInpatientProblemsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientInpatientProblems);
		getLink().setLinkByTitle(link);
	}

	public void setMiddleInitial(String middleInitial) {
		this.middleInitial = middleInitial;
	}

	public String getMiddleInitial() {
		return middleInitial;
	}

	public URI getAllergiesUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientAllergies);
		return AtomLink.extractUri(link);
	}

	public void setAllergiesUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientAllergies);
		getLink().setLinkByTitle(link);
	}

	public URI Surgeries() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientSurgeries);
		return AtomLink.extractUri(link);
	}

	public void setSurgeriesUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientSurgeries);
		getLink().setLinkByTitle(link);
	}

	public URI getLabResultsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientChemistryLabResults);
		return AtomLink.extractUri(link);
	}

	public URI getVitalsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientVitals);
		return AtomLink.extractUri(link);
	}
	
	public URI getLongitudinalVitalsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientVitalsLongitudinal);
		return AtomLink.extractUri(link);
	}
	
	public URI getOperationalVitalsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientVitalsOperational);
		return AtomLink.extractUri(link);
	}
	
	public URI getPatientEnteredVitalsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientEnteredVitals);
		return AtomLink.extractUri(link);
	}
	
	public URI getProviderEnteredVitalsTableDataUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientVitalsTableLongitudinal);
		return AtomLink.extractUri(link);
	}

	public URI getProviderEnteredVitalsGraphDataUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientVitalsGraphLongitudinal);
		return AtomLink.extractUri(link);
	}

	public void setLabResultsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientChemistryLabResults);
		getLink().setLinkByTitle(link);
	}

	public URI getLabTestHistoryUri() {
		return getLink().getUriByTitle(LinkTitles.PatientChemistryLabTestHistory);
	}

	public void setLabTestHistoryUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientChemistryLabTestHistory, uri);
	}

	public URI getLabTestHistoryByGroupUri() {
		return getLink().getUriByTitle(LinkTitles.PatientChemistryLabTestHistoryByGroup);
	}

	public void setLabTestHistoryByGroupUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientChemistryLabTestHistoryByGroup, uri);
	}

	public void setAge(String age) {
		this.age = age;
	}

	public String getAge() {
		return age;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	@XmlElement
	public String getDisplayName() {
		if(NullChecker.isNullish(displayName)){
			displayName = lastName + ", " + firstName;
		}
		return displayName;
	}

	@Override
	public int compareTo(Patient patient) {
		PatientSortingAlgorithm algorithm = new PatientSortingAlgorithm();
		return algorithm.compare(this, patient);
	}

	public void setPatientIdentifier(PatientIdentifier patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public PatientIdentifier getPatientIdentifier() {
		if (patientIdentifier == null)
			patientIdentifier = new PatientIdentifier();
		return patientIdentifier;
	}

	public static String serializePatientIdentifier(Patient patient) {
		String s = null;
		if (!(patient == null))
			s = patient.getPatientIdentifier().toString();
		return s;
	}

	public void setEnterpriseId(String enterpriseId) {
		this.enterpriseId = enterpriseId;
	}

	public String getEnterpriseId() {
		return enterpriseId;
	}

	public boolean isInpatient() {
		return inpatient;
	}

	public void setInpatient(boolean inpatient) {
		this.inpatient = inpatient;
	}

	public URI getMicroLabResultsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientMicrobiologyLabResults);
		return AtomLink.extractUri(link);
	}

	public void setMicroLabResultsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientMicrobiologyLabResults);
		getLink().setLinkByTitle(link);
	}

	public URI getMicroLabTestHistoryUri() {
		return getLink().getUriByTitle(LinkTitles.PatientMicrobiologyLabTestHistory);
	}

	public void setMicroLabTestHistoryUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientMicrobiologyLabTestHistory, uri);
	}

	public URI getMicroLabTestHistoryByGroupUri() {
		return getLink().getUriByTitle(LinkTitles.PatientMicrobiologyLabTestHistoryByGroup);
	}

	public void setMicroLabTestHistoryByGroupUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientMicrobiologyLabTestHistoryByGroup, uri);
	}

	public URI getMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientMedications);
		return AtomLink.extractUri(link);
	}

	public void setMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientMedications);
		getLink().setLinkByTitle(link);
	}

	public URI getActiveMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientActiveMedications);
		return AtomLink.extractUri(link);
	}

	public void setActiveMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientActiveMedications);
		getLink().setLinkByTitle(link);
	}

	public URI getMedicationRefillsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientMedicationRefills);
		return AtomLink.extractUri(link);
	}

	public void setMedicationRefillsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientMedicationRefills);
		getLink().setLinkByTitle(link);
	}

	public URI getOutpatientMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientOutpatientMedications);
		return AtomLink.extractUri(link);
	}

	public void setOutpatientMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientOutpatientMedications);
		getLink().setLinkByTitle(link);
	}

	public URI getCurrentOutpatientMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientActiveOutpatientMedications);
		return AtomLink.extractUri(link);
	}

	public void setCurrentOutpatientMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientActiveOutpatientMedications);
		getLink().setLinkByTitle(link);
	}

	public URI getInpatientMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientInpatientMedications);
		return AtomLink.extractUri(link);
	}

	public void setInpatientMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientInpatientMedications);
		getLink().setLinkByTitle(link);
	}

	public URI getCurrentInpatientMedicationsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientActiveInpatientMedications);
		return AtomLink.extractUri(link);
	}

	public void setCurrentInpatientMedicationsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientActiveInpatientMedications);
		getLink().setLinkByTitle(link);
	}
	
	public URI getMentalHealthAppointmentUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientMentalHealthAppointments);
		return AtomLink.extractUri(link);
	}

	public URI getAssessmentResultsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientAssessmentResults);
		return AtomLink.extractUri(link);
	}

	public void setAssessmentResultsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientAssessmentResults);
		getLink().setLinkByTitle(link);
	}

	public void setAssessmentDraftsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientAssessmentDraft);
		getLink().setLinkByTitle(link);
	}

	public URI getAssessmentGraphDataUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.PatientAssessmentGraphData);
		return AtomLink.extractUri(link);
	}

	public void setAssessmentGraphDataUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.PatientAssessmentGraphData);
		getLink().setLinkByTitle(link);
	}

	public URI getMygoalsUri() {
		AtomLink link = getLink().getLinkByTitle(LinkTitles.MyGoalsInventory);
		return AtomLink.extractUri(link);
	}

	public void setMygoalsUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.related);
		link.setTitle(LinkTitles.MyGoalsInventory);
		getLink().setLinkByTitle(link);
	}
	
	public boolean isTextMessagingAllowed() {
		return textMessagingAllowed;
	}

	public void setTextMessagingAllowed(boolean textMessagingAllowed) {
		this.textMessagingAllowed = textMessagingAllowed;
	}

	public String getTextMessagingPhoneNumber() {
		return textMessagingPhoneNumber;
	}

	public void setTextMessagingPhoneNumber(String textMessagingPhoneNumber) {
		this.textMessagingPhoneNumber = textMessagingPhoneNumber;
	}

}