package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.PainGoalEntryStatus;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "painGoalEntry", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PainGoalEntry extends PatientData {

	private static final long serialVersionUID = -7932789403513566317L;

	@XmlElement
	private String comments;
	@XmlElement 
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryDate;
	@XmlElement
	private String percentComplete;
	@XmlElement
	private PainGoalEntryStatus status;
	
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public Date getEntryDate() {
		return entryDate;
	}
	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}
	public String getPercentComplete() {
		return percentComplete;
	}
	public void setPercentComplete(String percentComplete) {
		this.percentComplete = percentComplete;
	}
	public PainGoalEntryStatus getStatus() {
		return status;
	}
	public void setStatus(PainGoalEntryStatus status) {
		this.status = status;
	}
	
	
}
