package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.PainGoalStatus;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "painGoal", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PainGoal extends PatientData implements Dateable{

	private static final long serialVersionUID = 2490093878226236660L;

	@XmlElement
	private String name;
	@XmlElement
	private PainGoalStatus status;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date dateStarted = null;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date targetDate = null;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date dateDeleted = null;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date dateCompleted = null;
	@XmlElement
	private String percentComplete;
	@XmlElement
	private String goalType;
	@XmlElement
	private String details;
	@XmlElement
	private String nextActionStep;
	@XmlElement
	private PainGoalEntries painGoalEntries;
	
	
	
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	@Enumerated(EnumType.STRING)
	public PainGoalStatus getStatus() {
		return status;
	}
	public void setStatus(PainGoalStatus status) {
		this.status = status;
	}
	public Date getDateStarted() {
		return dateStarted;
	}
	public void setDateStarted(Date dateStarted) {
		this.dateStarted = dateStarted;
	}
	public String getPercentComplete() {
		return percentComplete;
	}
	public void setPercentComplete(String percentComplete) {
		this.percentComplete = percentComplete;
	}
	public String getGoalType() {
		return goalType;
	}
	public void setGoalType(String goalType) {
		this.goalType = goalType;
	}
	public String getDetails() {
		return details;
	}
	public void setDetails(String details) {
		this.details = details;
	}
	public PainGoalEntries getPainGoalEntries() {
		return painGoalEntries;
	}
	public void setPainGoalEntries(PainGoalEntries painGoalEntries) {
		this.painGoalEntries = painGoalEntries;
	}
	public Date getTargetDate() {
		return targetDate;
	}
	public void setTargetDate(Date targetDate) {
		this.targetDate = targetDate;
	}
	public String getNextActionStep() {
		return nextActionStep;
	}
	public void setNextActionStep(String nextActionStep) {
		this.nextActionStep = nextActionStep;
	}
	public Date getDateCompleted() {
		return dateCompleted;
	}
	public void setDateCompleted(Date dateCompleted) {
		this.dateCompleted = dateCompleted;
	}
	public Date getDateDeleted() {
		return dateDeleted;
	}
	public void setDateDeleted(Date dateDeleted) {
		this.dateDeleted = dateDeleted;
	}

    @Override
    public Date getDate() {
        return this.getDateStarted();
    }
}
