package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "painDiaryReport", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PainDiaryReport extends PatientData {

	private static final long serialVersionUID = 3533231603116921585L;

	@XmlElement
	private String painType;
	@XmlElement
	private String itemsThatActivatedPain;
	@XmlElement
	private List<String> painQuality;
	@XmlElement
	private List<String> treatment;
	@XmlElement
	private String usefulnessOfTreatment;
	@XmlElement
	private String averagePainIntensity;
	@XmlElement
	private String painInterference;
	@XmlElement
	private String moodLevel;
	@XmlElement
	private String amountRefreshedAfterSleep;
	@XmlElement
	private String depressionLevel;
	@XmlElement
	private String impactOnWalking;
	@XmlElement
	private String itemsThatWorsenPain;
	@XmlElement
	private String itemsThatImprovedPain;
	@XmlElement
	private String comments;

	public String getPainType() {
		return painType;
	}

	public void setPainType(String painType) {
		this.painType = painType;
	}

	public String getItemsThatActivatedPain() {
		return itemsThatActivatedPain;
	}

	public void setItemsThatActivatedPain(String itemsThatActivatedPain) {
		this.itemsThatActivatedPain = itemsThatActivatedPain;
	}

	public List<String> getPainQuality() {
		return painQuality;
	}

	public void setPainQuality(List<String> painQuality) {
		this.painQuality = painQuality;
	}

	public List<String> getTreatment() {
		return treatment;
	}

	public void setTreatment(List<String> treatment) {
		this.treatment = treatment;
	}

	public String getUsefulnessOfTreatment() {
		return usefulnessOfTreatment;
	}

	public void setUsefulnessOfTreatment(String usefulnessOfTreatment) {
		this.usefulnessOfTreatment = usefulnessOfTreatment;
	}

	public String getAveragePainIntensity() {
		return averagePainIntensity;
	}

	public void setAveragePainIntensity(String averagePainIntensity) {
		this.averagePainIntensity = averagePainIntensity;
	}

	public String getPainInterference() {
		return painInterference;
	}

	public void setPainInterference(String painInterference) {
		this.painInterference = painInterference;
	}

	public String getMoodLevel() {
		return moodLevel;
	}

	public void setMoodLevel(String moodLevel) {
		this.moodLevel = moodLevel;
	}

	public String getAmountRefreshedAfterSleep() {
		return amountRefreshedAfterSleep;
	}

	public void setAmountRefreshedAfterSleep(String amountRefreshedAfterSleep) {
		this.amountRefreshedAfterSleep = amountRefreshedAfterSleep;
	}

	public String getDepressionLevel() {
		return depressionLevel;
	}

	public void setDepressionLevel(String depressionLevel) {
		this.depressionLevel = depressionLevel;
	}

	public String getImpactOnWalking() {
		return impactOnWalking;
	}

	public void setImpactOnWalking(String impactOnWalking) {
		this.impactOnWalking = impactOnWalking;
	}

	public String getItemsThatWorsenPain() {
		return itemsThatWorsenPain;
	}

	public void setItemsThatWorsenPain(String itemsThatWorsenPain) {
		this.itemsThatWorsenPain = itemsThatWorsenPain;
	}

	public String getItemsThatImprovedPain() {
		return itemsThatImprovedPain;
	}

	public void setItemsThatImprovedPain(String itemsThatImprovedPain) {
		this.itemsThatImprovedPain = itemsThatImprovedPain;
	}

	public String getComments() {
		return comments;
	}

	public void setComments(String comments) {
		this.comments = comments;
	}

}
