package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerAmPm;

@XmlRootElement(name = "painDiaryEntry", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class PainDiaryEntry extends PatientData implements Dateable {

	private static final long serialVersionUID = -2049157435308795761L;

	@XmlJavaTypeAdapter(DateTimeMarshallerAmPm.class)
	@XmlElement
	private Date dateCompleted = null;
	@XmlJavaTypeAdapter(DateTimeMarshallerAmPm.class)
	@XmlElement
	private Date dateCreated = null;
	@XmlElement
	private PainDiaryReport painQuestionValues;
	@XmlElement
	private boolean isCompleted;
	
	public Date getDateCompleted() {
		return dateCompleted;
	}
	public void setDateCompleted(Date dateCompleted) {
		this.dateCompleted = dateCompleted;
	}
	public PainDiaryReport getPainQuestionValues() {
		return painQuestionValues;
	}
	public void setPainQuestionValues(PainDiaryReport painQuestionValues) {
		this.painQuestionValues = painQuestionValues;
	}
	public boolean isCompleted() {
		return isCompleted;
	}
	public void setCompleted(boolean isCompleted) {
		this.isCompleted = isCompleted;
	}
	
	public Date getDateCreated() {
		return dateCreated;
	}
	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
	@Override
	public Date getDate() {
		return dateCreated;
	}

	
	
}
