package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.DOBDateMarshaller;
import com.agilex.healthcare.utility.NullSafeObjectComparer;
import com.agilex.healthcare.utility.NullSafeStringComparer;

public class NotificationUser extends DomainTransferObject {
	private static final long serialVersionUID = -5059916612878556410L;
	
	@XmlTransient
	String userId;

	@XmlAttribute
	String firstName;
	
	@XmlAttribute
	String lastName;
	
	@XmlAttribute
	String middleName;
	
	@XmlAttribute
	@XmlJavaTypeAdapter(DOBDateMarshaller.class)
	private DOBDate dateOfBirth;
	
	@XmlAttribute
	private String gender;
	
	@XmlAttribute
	private String ssn;
	
	@XmlAttribute
	private String age;
	
	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}
	
	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getMiddleName() {
		return middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public DOBDate getDateOfBirth() {
		return dateOfBirth;
	}

	public void setDateOfBirth(DOBDate dateOfBirth) {
		this.dateOfBirth = dateOfBirth;
	}

	public String getGender() {
		return gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

	public String getAge() {
		return age;
	}

	public void setAge(String age) {
		this.age = age;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		} else if (obj instanceof NotificationUser) {
			NotificationUser that = (NotificationUser) obj;
			
			if (this.userId == null && that.userId == null) {
				if (NullSafeStringComparer.areEqual(this.firstName, that.firstName)
					&& NullSafeStringComparer.areEqual(this.lastName, that.lastName)
					&& NullSafeStringComparer.areEqual(this.middleName, that.middleName)
					&& NullSafeObjectComparer.areEqual(this.dateOfBirth, that.dateOfBirth)
					&& NullSafeStringComparer.areEqual(this.ssn, that.ssn)
					&& NullSafeStringComparer.areEqual(this.age, that.age)) {
					return true;
				} else {
					return false;
				}
			} else {			
				return NullSafeStringComparer.areEqual(this.getUserId(), that.getUserId());
			}
		} else {
			return false;
		}
	}
	
	@Override
	public int hashCode() {
		return userId == null ? 0 : userId.hashCode();
	}
}
