package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;


@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "notification", namespace = Namespace.MobileHealthPlatform)
public class Notification extends PatientData implements Dateable {

	private static final long serialVersionUID = 4509837496728389595L;

	@XmlElement
	private String body;

	@XmlTransient
	private boolean activeFlag;

	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)	
	private Date date;
	
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date deletedDate;

	public String getNotificationId() {
		return this.getDataIdentifier().getUniqueId();
	}
	
	public void setNotificationId(String notificationId) {
		this.getDataIdentifier().setUniqueId(notificationId);
	}

	public String getUserId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	public void setUserId(String userId) {
		this.getPatientIdentifier().setUniqueId(userId);
	}

	public String getBody() {
		return body;
	}

	public void setBody(String body) {
		this.body = body;
	}

	public boolean isActiveFlag() {
		return activeFlag;
	}

	public void setActiveFlag(boolean activeFlag) {
		this.activeFlag = activeFlag;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public Date getDeletedDate() {
		return deletedDate;
	}

	public void setDeletedDate(Date deletedDate) {
		this.deletedDate = deletedDate;
	}
}
