package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "inventoryResponses", namespace = Namespace.MobileHealthPlatform)
public class MygoalsURI extends PatientData {

	private static final long serialVersionUID = -7951942644426656410L;
	
	private static final String LATEST = "latest";
	private static final String REPORT = "report";
	private static final String ALL = "all";
	
	@XmlElement
	public String getUri(){
		if(this.getSelfUri() != null){
			return getSelfUri().toString();
		}else{
			return null;
		}
	}

	@XmlElement
	public String getLatestUri() {
		return getUriByTitle(LATEST);
	}

	@XmlElement
	public String getReportUri() {
		return getUriByTitle(REPORT);
	}
	
	@XmlElement
	public String getAllUri() {
		return getUriByTitle(ALL);
	}

	private String getUriByTitle(String title){
		AtomLink link = getLink().getLinkByTitle(title);
		if (link != null) {
			return link.getHref().toString();
		} else {
			return null;
		}
	}	
	
}
