package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "response", namespace = Namespace.MobileHealthPlatform)
public class Mygoals extends PatientData implements Dateable {

	private static final long serialVersionUID = 6607171217260605471L;

	@XmlElement
	private String id;

	@XmlElement
	private String patientId;
	
	@XmlElement
	private String inventoryType;
	
	@XmlElement
	private String questionKey;
	
	@XmlElement
	private String answer;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date dateUpdated;
	
	@XmlElement
	private Integer elapsedTime;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getPatientId() {
		return patientId;
	}

	public void setPatientId(String patientId) {
		this.patientId = patientId;
	}

	public String getInventoryType() {
		return inventoryType;
	}

	public void setInventoryType(String inventoryType) {
		this.inventoryType = inventoryType;
	}

	public String getQuestionKey() {
		return questionKey;
	}

	public void setQuestionKey(String questionKey) {
		this.questionKey = questionKey;
	}

	public String getAnswer() {
		return answer;
	}

	public void setAnswer(String answer) {
		this.answer = answer;
	}

	public Date getDateUpdated() {
		return dateUpdated;
	}

	public void setDateUpdated(Date dateUpdated) {
		this.dateUpdated = dateUpdated;
	}
	@Override
	public Date getDate() {
		return this.dateUpdated;
	}
	
	public Integer getElapsedTime() {
		return elapsedTime;
	}

	public void setElapsedTime(Integer elapsedTime) {
		this.elapsedTime = elapsedTime;
	}
	
}
