package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlRootElement(name = "mood", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class MoodEvent extends PatientData implements Dateable {

	private static final long serialVersionUID = 1143449531484627050L;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date date;
	@XmlElement
	private String value;
	@XmlElement
	private String notes;

	@Override
	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}
	
	@Override
	public boolean equals(Object obj) {
		MoodEvent event = (MoodEvent) obj;
		if(event != null) {
			return this.getUniqueId().equals(event.getUniqueId());
		}
		return false;
	}
	
	@Override
	public int hashCode() {
		int result = 17;
		result = 31 * result + (date == null ? 0 : date.hashCode());
		result = 31 * result + (value == null ? 0 : value.hashCode());
		result = 31 * result + (notes == null ? 0 : notes.hashCode());
		return result;
	}
}