package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsInfo;

/**
 * This class represents user of the MHP system and it is not specific to any
 * implementation (i.e. Ovid/Vista vs. others). User attributes will be
 * encapsulated into this value object.
 * 
 */
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "mhpUser", namespace = Namespace.MobileHealthPlatform)
public class MhpUser extends DomainTransferObject implements Serializable {

	private static final long serialVersionUID = 103589672841204179L;
	@XmlElement
	protected String lastName;
	@XmlElement
	protected String firstName;
	@XmlElement
	protected String middleInitials;
	@XmlElement
	private String displayName;
	@XmlElement
	private String title;
	@XmlTransient
	private String accessCode;
	@XmlElement
	private Boolean rightOfAccessAccepted = null;
	@XmlElement
	private Boolean staffUserDisclaimerAccepted = null;
	@XmlElement
	private String vistaLocation;
	@XmlElement
	private String facilityName;
	@XmlElement
	private String userName;
	@XmlElement
	private PatientIdentifier userIdentifier = new PatientIdentifier();
	@XmlElement
    private Patient patient = new Patient();

    @XmlElement
    public String getId() {
		return userIdentifier.getUniqueId();
	}
    
    @XmlElement
    private MdwsInfo mdwsInfo;

	public MdwsInfo getMdwsInfo() {
		return mdwsInfo;
	}

	public void setMdwsInfo(MdwsInfo mdwsInfo) {
		this.mdwsInfo = mdwsInfo;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	@Deprecated
	public void setId(String id) {
	    userIdentifier.setUniqueId(id);
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleInitials() {
		return middleInitials;
	}

	public void setMiddleInitials(String middleInitials) {
		this.middleInitials = middleInitials;
	}

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getAccessCode() {
        return accessCode;
    }

    public void setAccessCode(String accessCode) {
        this.accessCode = accessCode;
    }

    public void setPatientUri(URI uri) {
        AtomLink link = new AtomLink();
        link.setHref(uri);
        link.setRel(rel.related);
        link.setTitle(LinkTitles.Patient);
        getLink().setLinkByTitle(link);
    }

    @XmlTransient
    public URI getPatientUri() {
        AtomLink link = getLink().getLinkByTitle(LinkTitles.Patient);
        return AtomLink.extractUri(link);
    }

    public Boolean hasAcceptedRightOfAccess() {
        return rightOfAccessAccepted;
    }

    public void setRightOfAccessAccepted(Boolean rightOfAccessAccepted) {
        this.rightOfAccessAccepted = rightOfAccessAccepted;
    }

    public Boolean isStaffUserDisclaimerAccepted() {
        return staffUserDisclaimerAccepted;
    }

    public void setStaffUserDisclaimerAccepted(Boolean staffUserDisclaimerAccepted) {
        this.staffUserDisclaimerAccepted = staffUserDisclaimerAccepted;
    }

    public String getVistaLocation() {
        return vistaLocation;
    }

    public void setVistaLocation(String vistaLocation) {
        this.vistaLocation = vistaLocation;
    }

    public PatientIdentifier getUserIdentifier() {
        return userIdentifier;
    }

    public void setUserIdentifier(PatientIdentifier patientIdentifier) {
        this.userIdentifier = patientIdentifier;
    }

    public String getFacilityName() {
        return facilityName;
    }

    public void setFacilityName(String facilityName) {
        this.facilityName = facilityName;
    }

	public String getPatientId() {
        if (patient == null || patient.getPatientIdentifier() == null || patient.getPatientIdentifier().getUniqueId() == null)
            return "";
        return patient.getPatientIdentifier().getUniqueId();
    }

    public void setPatientId(String patientId) {
        patient.getPatientIdentifier().setUniqueId(patientId);
    }

    public Patient getPatient() {
        if (patient == null)
            patient = new Patient();
        return patient;
    }

    public void setPatient(Patient patient) {
        this.patient = patient;
    }

    public String getPatientLastName() {
        if (patient == null || patient.getLastName() == null)
            return "";
        return patient.getLastName();
    }

    public String getPatientFirstName() {
        if (patient == null || patient.getFirstName() == null)
            return "";
        return patient.getFirstName();
    }

    public String getPatientMiddleName() {
        if (patient == null || patient.getMiddleName() == null)
            return "";
        return patient.getMiddleName();
    }

    public String getPatientDateOfBirth() {
        if (patient == null || patient.getDateOfBirth() == null)
            return "";
        return patient.getDateOfBirth().toString();
    }

    public boolean userIsPatient() {
        return userIdentifier != null && patient != null && patient.getPatientIdentifier() != null &&
                userIdentifier == patient.getPatientIdentifier();
    }

    @Override
	public String toString() {
		return "MhpUser id=[" + getId() + "] lastname=[" + lastName + "] firstname=[" + firstName + "] middle=[" + middleInitials + "]"; // title=[" + title + "]";
	}
}
