package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "medications", namespace = Namespace.MobileHealthPlatform)
public class Medications extends PatientDataCollection<Medication> {
	private static final long serialVersionUID = 9020213400373286696L;

    @XmlElement(namespace = Namespace.MobileHealthPlatform)
    private Integer prePaginationFilterSize;

	public Medications() {}

	public Medications(List<Medication> medications) {
		this.addAll(medications);
	}

	public Medications(Medication...medications) {
		for(int i = 0; i < medications.length; i++) {
			this.add(medications[i]);
		}
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<Medication> getMedication() {
		return this;
	}

    public Integer getPrePaginationFilterSize()
    {
        return prePaginationFilterSize;
    }

    public void setPrePaginationFilterSize(int prePaginationFilterSize)
    {
        this.prePaginationFilterSize = prePaginationFilterSize;
    }
}
