package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.*;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "medicationRefillRequest", namespace = Namespace.MobileHealthPlatform)
public class MedicationRefillRequests extends PatientDataCollection<MedicationRefillRequest> {

	private static final long serialVersionUID = 8341306077068581086L;

	public MedicationRefillRequests() {}
	
	public MedicationRefillRequests(MedicationRefillRequest... refillRequests) {
		for(MedicationRefillRequest refillRequest : refillRequests) {
			this.add(refillRequest);
		}
	}
	
	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<MedicationRefillRequest> getMedication() {
		return this;
	}
}
