package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlElement;

public class MedicationRefillRequest extends PatientData implements Dateable {

	private static final long serialVersionUID = -6968851189647760098L;

	@XmlElement
	private String medicationId;
	@XmlElement
	private Date requestDate;
	
	public MedicationRefillRequest() {}
	
	public MedicationRefillRequest(String patientId, String medicationId, Date requestDate) {
		setPatientId(patientId);
		setMedicationId(medicationId);
		setRequestDate(requestDate);
	}

	public String getId() {
		return getUniqueId();
	}

	public void setId(String id) {
		setUniqueId(id);
	}

	public String getPatientId() {
		return getPatientIdentifier().getUniqueId();
	}

	public void setPatientId(String patientId) {
		super.getPatientIdentifier().setUniqueId(patientId);
	}

	public String getMedicationId() {
		return medicationId;
	}

	public void setMedicationId(String medicationId) {
		this.medicationId = medicationId;
	}

	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

	@Override
	public Date getDate() {
		return getRequestDate();
	}

}
