package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;
import java.util.Date;
import java.util.Locale;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.*;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "medication", namespace = Namespace.MobileHealthPlatform)
public class Medication extends PatientData implements Dateable, Comparable<Medication> {

	private static final long serialVersionUID = -944825277352442820L;

	@XmlElement
	public String id;
	@XmlElement
	private String drugName;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date startDate;
	@XmlElement(required = false)
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date endDate;
	@XmlElement
	private String orderNumber;
	@XmlElement
	private String prescriptionId;
	@XmlElement
	private String medicationDetail;
	@XmlElement
	private String medicationSource;
	@XmlElement
	private String status;
	@XmlElement
	private String sig;
	@XmlElement
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	private Date lastFilledDate;
	@XmlElement
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	private Date calculatedNextFillDate;
	@XmlElement
	@XmlJavaTypeAdapter(SimpleDateMarshaller.class)
	private Date expiredDate;
	@XmlElement
	private String refills;
	@XmlElement
	private String refillAction;
	@XmlElement
	private Integer refillsRemaining;
	@XmlElement
	private Integer totalRefills;
	@XmlElement
	private boolean eligibleForRefill;
	@XmlElement
	private String quantity;
	@XmlElement
	private String daysSupply;
	@XmlElement
	private String category;
	@XmlElement
	private String pharmacy;

	public String getId() {
		return getUniqueId();
	}

	public void setId(String id) {
		this.id = id;
	}

	public void setDrugName(String drugName) {
		this.drugName = drugName;
	}

	public String getDrugName() {
		return drugName;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getStartDate() {
		return startDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Date getEndDate() {
		return endDate;
	}

	/**
	 * Please use {@link #setStatus(String)} instead
	 * 
	 */
	@Deprecated 
	public void setActive(boolean active) {
		if(active == true) {
			setStatus("ACTIVE");
		} else {
			setStatus("EXPIRED");
		}
	}

	@XmlElement
	public boolean isActive() {
		return "active".equalsIgnoreCase(getStatus());
	}

	public void setOrderNumber(String orderNumber) {
		this.orderNumber = orderNumber;
	}

	public String getOrderNumber() {
		return orderNumber;
	}

	public void setMedicationSource(String medicationSource) {
		this.medicationSource = medicationSource;
	}

	public String getMedicationSource() {
		return medicationSource;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getStatus() {
		return status;
	}

	public void setSig(String sig) {
		this.sig = sig;
	}

	public String getSig() {
		return sig;
	}

	public void setLastFilledDate(Date lastFilledDate) {
		this.lastFilledDate = lastFilledDate;
	}

	public Date getLastFilledDate() {
		return lastFilledDate;
	}
	
	public Date getCalculatedNextFillDate() {
		return calculatedNextFillDate;
	}

	public void setCalculatedNextFillDate(Date calculatedNextFillDate) {
		this.calculatedNextFillDate = calculatedNextFillDate;
	}

	public void setExpiredDate(Date expiredDate) {
		this.expiredDate = expiredDate;
	}

	public Date getExpiredDate() {
		return expiredDate;
	}

	public void setRefills(String refills) {
		this.refills = refills;
	}

	public String getRefills() {
		return refills;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	public String getQuantity() {
		return quantity;
	}

	public String getDaysSupply() {
		return daysSupply;
	}

	public void setDaysSupply(String daysSupply) {
		this.daysSupply = daysSupply;
	}

	public String getPrescriptionId() {
		return prescriptionId;
	}

	public void setPrescriptionId(String prescriptionId) {
		this.prescriptionId = prescriptionId;
	}

	public String getMedicationDetail() {
		return medicationDetail;
	}

	public void setMedicationDetail(String medicationDetail) {
		this.medicationDetail = medicationDetail;
	}

	public void setMedicationDetailUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientMedicationDetail, uri);
	}

	public AtomLink getMedicationDetailLink() {
		return getLink().getLinkByTitle(LinkTitles.PatientMedicationDetail);
	}

	public String getCategory() {
		return category;
	}

	public void setCategory(String category) {
		this.category = category;
	}

	public String getPharmacy() {
		return pharmacy;
	}

	public void setPharmacy(String pharmacy) {
		this.pharmacy = pharmacy;
	}

	@Override
	public Date getDate() {
		return getStartDate();
	}

	@Override
	public DataIdentifier getDataIdentifier() {
		DataIdentifier identifier = super.getDataIdentifier();

		if(identifier.getUniqueId() == null)
			identifier.setUniqueId(getOrderNumber());
		
		return identifier;
	}

	public String getRefillAction() {
		return refillAction;
	}

	public void setRefillAction(String refillAction) {
		this.refillAction = refillAction;
	}

	public Integer getTotalRefills() {
		return totalRefills;
	}

	public void setTotalRefills(Integer totalRefills) {
		this.totalRefills = totalRefills;
	}

	public boolean isEligibleForRefill() {
		return eligibleForRefill;
	}

	public void setEligibleForRefill(boolean eligibleForRefill) {
		this.eligibleForRefill = eligibleForRefill;
	}

	public Integer getRefillsRemaining() {
		return refillsRemaining;
	}

	public void setRefillsRemaining(Integer refillsRemaining) {
		this.refillsRemaining = refillsRemaining;
	}
	
	

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime * result + ((category == null) ? 0 : category.hashCode());
		result = prime * result + ((daysSupply == null) ? 0 : daysSupply.hashCode());
		result = prime * result + ((drugName == null) ? 0 : drugName.hashCode());
		result = prime * result + (eligibleForRefill ? 1231 : 1237);
		result = prime * result + ((endDate == null) ? 0 : endDate.hashCode());
		result = prime * result + ((expiredDate == null) ? 0 : expiredDate.hashCode());
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((lastFilledDate == null) ? 0 : lastFilledDate.hashCode());
		result = prime * result + ((medicationDetail == null) ? 0 : medicationDetail.hashCode());
		result = prime * result + ((medicationSource == null) ? 0 : medicationSource.hashCode());
		result = prime * result + ((orderNumber == null) ? 0 : orderNumber.hashCode());
		result = prime * result + ((pharmacy == null) ? 0 : pharmacy.hashCode());
		result = prime * result + ((prescriptionId == null) ? 0 : prescriptionId.hashCode());
		result = prime * result + ((quantity == null) ? 0 : quantity.hashCode());
		result = prime * result + ((refillAction == null) ? 0 : refillAction.hashCode());
		result = prime * result + ((refills == null) ? 0 : refills.hashCode());
		result = prime * result + ((refillsRemaining == null) ? 0 : refillsRemaining.hashCode());
		result = prime * result + ((sig == null) ? 0 : sig.hashCode());
		result = prime * result + ((startDate == null) ? 0 : startDate.hashCode());
		result = prime * result + ((status == null) ? 0 : status.hashCode());
		result = prime * result + ((totalRefills == null) ? 0 : totalRefills.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		Medication other = (Medication) obj;
		if (category == null) {
			if (other.category != null)
				return false;
		} else if (!category.equals(other.category))
			return false;
		if (daysSupply == null) {
			if (other.daysSupply != null)
				return false;
		} else if (!daysSupply.equals(other.daysSupply))
			return false;
		if (drugName == null) {
			if (other.drugName != null)
				return false;
		} else if (!drugName.equals(other.drugName))
			return false;
		if (eligibleForRefill != other.eligibleForRefill)
			return false;
		if (endDate == null) {
			if (other.endDate != null)
				return false;
		} else if (!endDate.equals(other.endDate))
			return false;
		if (expiredDate == null) {
			if (other.expiredDate != null)
				return false;
		} else if (!expiredDate.equals(other.expiredDate))
			return false;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (lastFilledDate == null) {
			if (other.lastFilledDate != null)
				return false;
		} else if (!lastFilledDate.equals(other.lastFilledDate))
			return false;
		if (medicationDetail == null) {
			if (other.medicationDetail != null)
				return false;
		} else if (!medicationDetail.equals(other.medicationDetail))
			return false;
		if (medicationSource == null) {
			if (other.medicationSource != null)
				return false;
		} else if (!medicationSource.equals(other.medicationSource))
			return false;
		if (orderNumber == null) {
			if (other.orderNumber != null)
				return false;
		} else if (!orderNumber.equals(other.orderNumber))
			return false;
		if (pharmacy == null) {
			if (other.pharmacy != null)
				return false;
		} else if (!pharmacy.equals(other.pharmacy))
			return false;
		if (prescriptionId == null) {
			if (other.prescriptionId != null)
				return false;
		} else if (!prescriptionId.equals(other.prescriptionId))
			return false;
		if (quantity == null) {
			if (other.quantity != null)
				return false;
		} else if (!quantity.equals(other.quantity))
			return false;
		if (refillAction == null) {
			if (other.refillAction != null)
				return false;
		} else if (!refillAction.equals(other.refillAction))
			return false;
		if (refills == null) {
			if (other.refills != null)
				return false;
		} else if (!refills.equals(other.refills))
			return false;
		if (refillsRemaining == null) {
			if (other.refillsRemaining != null)
				return false;
		} else if (!refillsRemaining.equals(other.refillsRemaining))
			return false;
		if (sig == null) {
			if (other.sig != null)
				return false;
		} else if (!sig.equals(other.sig))
			return false;
		if (startDate == null) {
			if (other.startDate != null)
				return false;
		} else if (!startDate.equals(other.startDate))
			return false;
		if (status == null) {
			if (other.status != null)
				return false;
		} else if (!status.equals(other.status))
			return false;
		if (totalRefills == null) {
			if (other.totalRefills != null)
				return false;
		} else if (!totalRefills.equals(other.totalRefills))
			return false;
		return true;
	}

	@Override
	public int compareTo(Medication o) {
		int result;
		
		if (this.getStatus() == null || o.getStatus() == null) {
			if (this.getStatus() == null && o.getStatus() == null) {
				result = 0;
			} else if (this.getStatus() == null) {
				result = -1;
			} else {
				result = 1;
			}
		} else {
			result = this.getStatus().compareTo(o.getStatus());
		}
		
		if (result == 0) {
			if (this.getDrugName() == null || o.getDrugName() == null) {
				if (this.getDrugName() == null && o.getDrugName() == null) {
					result = 0;
				} else if (this.getDrugName() == null) {
					result = -1;
				} else {
					result = 1;
				}
			} else {
				result = this.getDrugName().toLowerCase(Locale.ENGLISH).compareTo(o.getDrugName().toLowerCase(Locale.ENGLISH));	
			}
		}
		
		return result;
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		
		sb.append(this.orderNumber);
		sb.append(" ");
		sb.append(this.drugName);
		sb.append(" ");
		sb.append(this.pharmacy);
		sb.append(" ");
		sb.append(this.medicationSource);
		sb.append(" ");
		sb.append(this.status);
		sb.append(" ");
		sb.append(this.sig);
		
		return sb.toString();
	}
}
