package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.Iterator;

import javax.xml.bind.annotation.*;

import com.agilex.healthcare.mobilehealthplatform.domain.DomainTransferObjectCollection;
import com.agilex.healthcare.mobilehealthplatform.domain.Namespace;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "mdwskeys", namespace = Namespace.MobileHealthPlatform)
public class MdwsKeys extends DomainTransferObjectCollection<MdwsKey> {
	private static final long serialVersionUID = -7782610185456687499L;

	public MdwsKeys() {}

	public MdwsKeys(MdwsKey... mdwsKey) {
		for (int i = 0; i < mdwsKey.length; i++) {
			this.add(mdwsKey[i]);
		}
	}
	
	/**
	 * Convenience method to find out whether a MdwsKey exists in this collection.
	 */
	public boolean keyExists(String keyName) {
		if (keyName == null)
			return false;
		
		Iterator<MdwsKey> i = this.iterator();
        while (i.hasNext()) {
        	MdwsKey c = i.next();
        	if (keyName.equalsIgnoreCase(c.getName()))
        		return true;
        }
		
		return false;
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<MdwsKey> getMdwsKey() {
		return this;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("MdwsKeys (" + this.size() + "):");
		
		Iterator<MdwsKey> i = this.iterator();
        while (i.hasNext()) {
        	MdwsKey c = i.next();
        	String s = String.format("%n%s", c.toString());
        	sb.append(s);
        }

		return sb.toString();
	}
}
