package com.agilex.healthcare.mobilehealthplatform.domain;

public class LinkTitles {
	public static final String SystemRoot = "system-root";

	public static final String Patient = "patient";

	public static final String PatientIdentifiers = "patient-identifiers";
	public static final String PatientDemographics = "patient-demographics";
	public static final String PatientPreference = "patient-preference";
	public static final String DocumentContent = "document-content";
	public static final String PatientDocuments = "patient-documents";
	public static final String PatientImage = "patient-image";
	public static final String PatientAllergies = "patient-allergies";

	public static final String PatientMedications = "patient-medications";
	public static final String PatientActiveMedications = "patient-medications-active";
	public static final String PatientOutpatientMedications = "patient-medications-outpatient";
	public static final String PatientInpatientMedications = "patient-medications-inpatient";
	public static final String PatientActiveOutpatientMedications = "patient-medications-outpatient-active";
	public static final String PatientActiveInpatientMedications = "patient-medications-inpatient-active";
	public static final String PatientMedicationDetail = "patient-medication-detail";
	public static final String PatientMedicationRefills = "patient-medication-refills";
	public static final String PatientMedicationsLongitudinalScope = "patient-medications-longitudinal";
	public static final String PatientMedicationsOperationalScope = "patient-medications-operational";
	public static final String PatientMedicationsActiveLongitudinalScope = "patient-medications-longitudinal-active";
	public static final String PatientMedicationsActiveOperationalScope = "patient-medications-operational-active";
	public static final String PatientMedicationsOutpatientLongitudinalScope = "patient-medications-outpatient-longitudinal";
	public static final String PatientMedicationsOutpatientOperationalScope = "patient-medications-outpatient-operational";
	public static final String PatientMedicationsInpatientLongitudinalScope = "patient-medications-inpatient-longitudinal";
	public static final String PatientMedicationsInpatientOperationalScope = "patient-medications-inpatient-operational";
	public static final String PatientMedicationsActiveOutpatientLongitudinalScope = "patient-medications-outpatient-longitudinal-active";
	public static final String PatientMedicationsActiveOutpatientOperationalScope = "patient-medications-outpatient-operational-active";
	public static final String PatientMedicationsActiveInpatientLongitudinalScope = "patient-medications-inpatient-longitudinal-active";
	public static final String PatientMedicationsActiveInpatientOperationalScope = "patient-medications-inpatient-operational-active";

	public static final String PatientMicrobiologyLabResults = "patient-lab-micro-results";
	public static final String PatientMicrobiologyLabTestHistory = "patient-lab-micro-tests";
	public static final String PatientMicrobiologyLabResultsForTest = "patient-lab-micro-results-fortest";
	public static final String PatientMicrobiologyLabTestHistoryByGroup = "patient-lab-micro-tests-by-group";

	public static final String PatientChemistryLabResults = "patient-lab-results";
	public static final String PatientChemistryLabTestHistory = "patient-lab-tests";
	public static final String PatientChemistryLabResultsForTest = "patient-lab-results-for-test";
	public static final String PatientChemistryLabTestHistoryByGroup = "patient-lab-tests-by-group";

	public static final String PatientProblems = "patient-problems";
	public static final String PatientProblemsLongitudinal = "patient-problems-longitudinal";
	public static final String PatientProblemsOperational = "patient-problems-operational";
	public static final String PatientOutpatientProblems = "patient-problems-outpatient";
	public static final String PatientInpatientProblems = "patient-problems-inpatient";
	
	public static final String PatientMood = "patient-mood";
	public static final String PatientDiet = "patient-diet";
	public static final String PatientExercise = "patient-exercise";
	public static final String PatientSurgeries = "patient-surgeries";

	public static final String PatientPastAppointments = "patient-appointments-past";
	public static final String PatientAppointments = "patient-appointments";
	public static final String PatientMentalHealthAppointments = "patient-appointments-mental-health";
	public static final String PatientAppointmentsLongitudinal = "patient-appointments-longitudinal";
	public static final String PatientAppointmentsOperational = "patient-appointments-operational";
	public static final String PatientFutureAppointments = "patient-appointments-future";
	public static final String PatientCalendarPublicKey = "patient-calendar-publickey";
	public static final String PatientCalendarEvents = "patient-calendar-events";
	public static final String PatientContactLogs = "patient-contactlogs";
	public static final String PatientAdmissions = "patient-admisions";

	public static final String PatientVitals = "patient-vitals";
	public static final String PatientVitalsLongitudinal = "patient-vitals-longitudinal";
	public static final String PatientVitalsOperational = "patient-vitals-operational";
	public static final String PatientVitalsGraphLongitudinal = "patient-vitals-graphdata-longitudinal";
	public static final String PatientVitalsGraphOperational = "patient-vitals-graphdata-operational";
	public static final String PatientVitalsTableLongitudinal = "patient-vitals-tabledata-longitudinal";
	public static final String PatientVitalsTableOperational = "patient-vitals-tabledata-operational";
	
	public static final String PatientEnteredVitals = "patient-entered-vitals";
	public static final String PatientEnteredVitalsBloodPressure = "patient-entered-vitals-bloodpressure";
	public static final String PatientEnteredVitalsHeight = "patient-entered-vitals-height";
	public static final String PatientEnteredVitalsWeight = "patient-entered-vitals-weight";
	public static final String PatientEnteredVitalsPain = "patient-entered-vitals-pain";
	public static final String PatientEnteredVitalsRespiration = "patient-entered-vitals-respiration";
	public static final String PatientEnteredVitalsTemperature = "patient-entered-vitals-temperature";
	public static final String PatientEnteredVitalsGraphData = "patient-entered-vitals-graphdata";
	public static final String PatientEnteredVitalsTableData = "patient-entered-vitals-tabledata";
	
	public static final String PatientRadiologyTests = "patient-radiology-tests";
	public static final String PatientRadiologyResults = "patient-radiology-results";

	public static final String DailyEvents = "patient-daily-events";

	public static final String RelatedDocuments = "related-documents";
	public static final String RelatedMedicationRefills = "related-medication-refills";

	public static final String PatientNotifications = "patient-notifications";
	public static final String UserNotifications = "notifications";
	public static final String UserNotificationAuditLogs = "notifications-auditLogs";
	public static final String PatientDevices = "patient-devices";

	public static final String RightOfAccess = "right-of-access";
	public static final String RightOfAccessPDF = "right-of-access-pdf";
	public static final String RightOfAccessImage = "right-of-access-image";

	public static final String SecureMessageUser = "securemessage-user";

	public static final String LearnCategories = "learn-categories";

	public static final String AppointmentsMetadata = "appointments-metadata";
	public static final String Appointments = "appointments";

	public static final String Assessments = "assessments";
	public static final String AssessmentResults = "assessment-results";
	
	public static final String PatientAssessmentResults = "patient-assessment-results";
	public static final String PatientAssessmentGraphData = "patient-assessment-graphdata";
	public static final String PatientPainManagementGraphData = "patient-painmanagement-graphdata";
    public static final String PatientPainManagementSummaryReport = "patient-painmanagement-summaryreport";
	public static final String PatientAssessmentDraft = "patient-assessment-draft";
	public static final String PatientAssessmentEligibility = "patient-assessment-eligibility";

	public static final String HealthAssessmentAssessments = "health-assessment-assessments";
	public static final String MHPUser = "mhpuser";
	public static final String PrimaryCareProviders = "providers-primarycare";
	public static final String MentalHealthProviders = "providers-mentalhealth";
	public static final String MostRecentFacilities = "most-recent-facilities";
	
	public static final String AppointmentRequests = "appointment-requests";
    public static final String AppointmentRequestMessages = "appointment-request-messages";
    public static final String AppointmentRequestNewMessageFlag = "appointment-request-new-message-flag";
    public static final String AppointmentRequestProviderSeenFlag = "appointment-request-provider-seen-flag";
    
	public static final String AppointmentMetricsNoIcnOrDfn = "no-icn-or-dfn-metric";
	public static final String AppointmentMetricsNoDfnCancelRequest = "no-dfn-cancel-request-metric";
	public static final String PatientInternal = "internal-patient-data";

	public static final String HealthAdvocateRequest = "health-advocate-requests";
	public static final String HealthAdvocateRequestFormDetail = "health-advocate-request-form-detail";
	public static final String HealthAdvocateRequestRevokedFormDetail = "health-advocate-request-revoked-form-detail";
	public static final String HealthAdvocateRequestCancelledFormDetail = "health-advocate-request-cancelled-form-detail";

    public static final String HealthAdvocateRequestAcceptFormDetail = "health-advocate-request-accept-form-detail";
    public static final String HealthAdvocateRequestAcceptCancelledFormDetail = "health-advocate-request-accept-cancelled-form-detail";
    public static final String HealthAdvocateRequestAcceptRevokedFormDetail = "health-advocate-request-accept-revoked-form-detail";

	public static final String HealthAdvocateRequestEligibility = "health-advocate-requests-eligibility";

	public static final String AppointmentRequestFeedback = "feedback-appointment-request";

	public static final String PainDiary = "pain-diary";

	public static final String AppointmentRequestInProcess = "appointment-request-in-process";
    public static final String PainGoals = "pain-goals";

	public static final String PainGoalsReport = "pain-goals-report";

	public static final String ToolTrackingResults = "tool-tracking-result";
    public static final String OAuthAuthorize = "oauth-authorize";
    public static final String OAuthLogin = "oauth-login";
	public static final String OAuthToken = "oauth-token";
    public static final String LaunchpadMetadata = "launchpad-metadata";
    public static final String LaunchpadItem = "launchpad-launchpadItem";
    public static final String LaunchpadInstruction = "launchpad-instruction";
    public static final String UserSession = "user-session";
    public static final String PublicUserSession = "public-user-session";
    public static final String AntibiogramFacility = "antibiogram-facility";
    public static final String MyGoalsInventory = "mygoals-inventory";
    public static final String CustomDataView = "custom-data-view";

    public static final String MbbReport = "mbb-report";
    public static final String MbbDomains = "mbb-domains";
    
	public static final String LabTestReferenceLink = "lab-test-reference-link";
	public static final String StaffUserDisclaimer = "staff-user-disclaimer";
	public static final String StaffUserDisclaimerContent = "staff-user-disclaimer-content";
	
	public static final String StaffDirectory = "staff-directory";
	
	public static final String PatientContextLink = "patient-context";

    public static final String LaunchPadLink = "launchpad-link";
	
    // prevent class from being instantiated
	private LinkTitles() {
	}
}
