package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "learnSubCategory", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class LearnSubCategory extends DomainTransferObject {
	private static final long serialVersionUID = 1612335150353907436L;

	@XmlElement
	private String id;
	@XmlElement
	private String title;
	@XmlElement(name="article")
	private LearnArticles articles = new LearnArticles();
	@XmlAttribute(name = "size")
	private int numberOfArticles = 0;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public LearnArticles getArticles() {
		return articles;
	}

	public void setArticles(LearnArticles articles) {
		this.articles = articles;
		numberOfArticles = articles.size();
	}

	public int getNumberOfArticles() {
		return numberOfArticles;
	}
}
