package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "learnSubCategories", namespace = Namespace.MobileHealthPlatform)
public class LearnSubCategories extends DomainTransferObjectCollection<LearnSubCategory> {
	private static final long serialVersionUID = -6058684459726808803L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<LearnSubCategory> getLearnSubCategory() {
		return this;
	}

	public LearnSubCategory getSubCategoryById(String subCategoryId) {
		for (LearnSubCategory subCategoryToCompare : this) {
			if (subCategoryToCompare.getId().equals(subCategoryId)) {
				return subCategoryToCompare;
			}
		}
		return null;
	}
}
