package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "learnCategory", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class LearnCategory extends DomainTransferObject {
	private static final long serialVersionUID = -4659264896210022766L;

	@XmlElement
	private String title;
	@XmlElement
	private String id;
	@XmlElement
	private String icon;
	@XmlElement(name = "subCategory")
	private LearnSubCategories subCategories = new LearnSubCategories();
	@XmlAttribute(name = "size")
	private int numberOfSubCategories = 0;
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public LearnSubCategories getSubCategories() {
		return subCategories;
	}

	public void setSubCategories(LearnSubCategories subCategories) {
		this.subCategories = subCategories;
		numberOfSubCategories = subCategories.size();
	}

	public int getNumberOfSubCategories() {
		return numberOfSubCategories;
	}

	public void setIcon(String icon) {
		this.icon = icon;
	}

	public String getIcon() {
		return icon;
	}
}
