package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "learnCategories", namespace = Namespace.MobileHealthPlatform)
public class LearnCategories extends DomainTransferObjectCollection<LearnCategory>{
	private static final long serialVersionUID = -6058684459726808803L;

	@XmlElement(namespace=Namespace.MobileHealthPlatform)
	public Collection<LearnCategory> getLearnCategory() {
		return this;
	}	

	public LearnCategory getCategoryById(String id) {
		Collection<LearnCategory> categories = this;
		LearnCategory categoryMatch = null;
		for (LearnCategory category : categories) {
			if (category.getId().equals(id)) {
				categoryMatch = category;
			}
		}
		return categoryMatch;
	}
}
