package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name = "learnArticles", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class LearnArticles extends DomainTransferObjectCollection<LearnArticle> {
	private static final long serialVersionUID = 2571633037246138126L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<LearnArticle> getLearnArticle() {
		return this;
	}
	
	public LearnArticle getArticleById(String articleId) {
		for (LearnArticle articleToCompare : this) {
			if (articleToCompare.getId().equals(articleId)) {
				return articleToCompare;
			}
		}
		return null;
	}
}
