package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;

import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.enumeration.LaunchpadItemType;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "launchpadItem", namespace = Namespace.MobileHealthPlatform)
public class LaunchpadItem implements Serializable, Comparable<LaunchpadItem> {

	private static final long serialVersionUID = -8284247179519778613L;

	@XmlElement
	private String name;

	@XmlElement
	private LaunchpadItemType type;
	
	@XmlElement
	private URI url;
	
	@XmlElement
	private String imageUrl;
	
	@XmlElement
	private String description;
	
	@XmlElement
	private int position;
	
	@XmlElement
	private Date instrUpdatedDate;
	
	@XmlElement
	private String instruction;
	
	@XmlElement
	private String updatedBy;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public LaunchpadItemType getType() {
		return type;
	}

	public void setType(LaunchpadItemType type) {
		this.type = type;
	}

	public URI getUrl() {
		return url;
	}

	public void setUrl(URI url) {
		this.url = url;
	}

    public void setUrl(String url) { this.url = UriBuilder.fromUri(url).build(); }

	public String getImageUrl() {
		return imageUrl;
	}

	public void setImageUrl(String imageUrl) {
		this.imageUrl = imageUrl;
	}

	public int getPosition() {
		return position;
	}

	public void setPosition(int position) {
		this.position = position;
	}

	@Override
	public int compareTo(LaunchpadItem o) {
		int result;
		
		if (this.position > o.position) {
			result = 1;
		} else if (this.position < o.position) {
			result = -1;
		} else {
			result = 0;
		}
		
		return result;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getInstrUpdatedDate() {
		return instrUpdatedDate;
	}

	public void setInstrUpdatedDate(Date instrUpdatedDate) {
		this.instrUpdatedDate = instrUpdatedDate;
	}

	public String getInstruction() {
		return instruction;
	}

	public void setInstruction(String instruction) {
		this.instruction = instruction;
	}

	public String getUpdatedBy() {
		return updatedBy;
	}

	public void setUpdatedBy(String updatedBy) {
		this.updatedBy = updatedBy;
	}
	
}
