package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform)
public class LabTestGroup extends DomainTransferObject {

	private static final long serialVersionUID = -2924774523196464251L;

	@XmlAttribute
	private String name;
	@XmlAttribute
	private String id;
	
	@XmlElement(name = "labTest", namespace = Namespace.MobileHealthPlatform)
	private LabTests labTests = new LabTests();

	public LabTestGroup() {}
	
	public LabTestGroup(String name) {
		this.name = name;
	}
	
	public LabTestGroup(String name, LabTests labTests) {
		setName(name);
		setLabTests(labTests);
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public String getName() {
		return name;
	}

	@Override
	public String toString() {
		return getName();
	}

	public LabTests getLabTests() {
		return labTests;
	}
	
	public void addLabTest(LabTest labTest) {
		this.labTests.add(labTest);
	}

	public void setLabTests(LabTests labTests) {
		this.labTests = labTests;
	}

	@Override
	public boolean equals(Object inputObj) {

		if (!(inputObj instanceof LabTestGroup)) {
			return false;
		}

		String inputGroupName = ((LabTestGroup) inputObj).getName().trim().toLowerCase();

		String groupName = name.trim().toLowerCase();

		return groupName.equalsIgnoreCase(inputGroupName);
	}

	@Override
	public int hashCode() {
		return name.hashCode();
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getId() {
		return id;
	}

}
