package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.utility.NullChecker;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "labtest", namespace = Namespace.MobileHealthPlatform)
public class LabTest extends PatientData implements Comparable<LabTest> {

	private static final long serialVersionUID = 7975019513233324247L;

	@XmlElement
	private String specimenId = null;
	@XmlElement
	private String specimenName = null;

	private String testname = null;
	@XmlElement
	private String loinc = "";
	@XmlElement
	private String testDescription = null;

	private int sortOrder = Integer.MAX_VALUE;

	@XmlElement(name = "labResult", namespace = Namespace.MobileHealthPlatform)
	private LabResult mostRecentLabResult = null;

	@XmlElement(name = "labResult")
	private LabResults labResults = new LabResults();

	@XmlAttribute
	public String getTestname() {
		return getDisplayName();
	}

	public void setTestname(String testname) {
		this.testname = testname;
	}

	public void setMostRecentLabResult(LabResult mostRecentLabResult) {
		this.mostRecentLabResult = mostRecentLabResult;
	}

	public LabResult getMostRecentLabResult() {
		return mostRecentLabResult;
	}

	public void setLabResultsForTestUri(URI uri) {
		getLink().addRelatedLink(LinkTitles.PatientChemistryLabResultsForTest, uri);
	}

	public AtomLink getLabResultsForTestLink() {
		return getLink().getLinkByTitle(LinkTitles.PatientChemistryLabResultsForTest);
	}

	public URI getLabResultsForTestUri() {
		return AtomLink.extractUri(getLabResultsForTestLink());
	}

	public void setSpecimenId(String specimen) {
		this.specimenId = specimen;
	}

	public String getSpecimenId() {
		return specimenId;
	}

	public String getSpecimenName() {
		return specimenName;
	}

	public void setSpecimenName(String specimenName) {
		this.specimenName = specimenName;
	}

	@XmlAttribute
	public String getDisplayName() {
		String displayName = testname;

		if (NullChecker.isNotNullish(specimenName)) {
			return displayName + " (" + specimenName + ")";
		}

		return displayName;
	}

	public LabResults getLabResults() {
		return labResults;
	}

	public void setLabResults(LabResults labResults) {
		this.labResults = labResults;
	}

	public String getTestDescription() {
		return testDescription;
	}

	public void setTestDescription(String testDescription) {
		this.testDescription = testDescription;
	}

	public String getLoinc() {
		return loinc;
	}

	public void setLoinc(String loinc) {
		this.loinc = loinc;
	}

	public String getGroupingId() {
		if (NullChecker.isNotNullish(getLoinc()))
			return getLoinc();
		else if (NullChecker.isNotNullish(getUniqueId()) && NullChecker.isNotNullish(getSpecimenName()))
			return getUniqueId() + "-" + getSpecimenName();

		return testname;
	}

	@Override
	public int compareTo(LabTest that) {
		int result = this.testname.compareTo(that.testname);
		if (result == 0) {
			result = this.getLabResults().get(0).getResultedDate().compareTo(that.getLabResults().get(0).getResultedDate()) * -1;
		}

		return result;
	}

	public int getSortOrder() {
		return sortOrder;
	}

	public void setSortOrder(int sortOrder) {
		this.sortOrder = sortOrder;
	}

	// @Deprecated
	// public String getId() {
	// return super.getUniqueId();
	// }
	//
	// @Deprecated
	// public void setId(String id) {
	// super.setUniqueId(id);
	// }

}
