package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.*;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(namespace = Namespace.MobileHealthPlatform)
public class LabResult extends PatientData implements Dateable, Comparable<LabResult> {
	
	private static final long serialVersionUID = -4103550347391499268L;
	
	@XmlAttribute
	private String testId = null;
	@XmlAttribute
	private String testname = null;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date resultedDate = null;
	@XmlAttribute
	private String value = null;
	@XmlAttribute
	private String valueUnits = null;
	@XmlAttribute(required = false)
	private String referenceHigh = null;
	@XmlAttribute(required = false)
	private String referenceLow = null;
	@XmlAttribute
	private String indicator = null;
	@XmlAttribute
	private boolean abnormalIndicatorFlag = false;
	@XmlJavaTypeAdapter(TriStateJaxbAdapter.class)
	@XmlAttribute
	private TriState abnormalIndicatorTriFlag = TriState.UNKNOWN;
	@XmlAttribute
	private String accessionNumber = null;
	@XmlAttribute
	private String labtype = null;
	@XmlAttribute
	private String status = null;
	@XmlElement
	private String comment = null;
	@XmlAttribute
	private String orderId = null;
	@XmlAttribute
	private String specimenId = null;
	@XmlAttribute
	private String specimenName = null;
	@XmlAttribute
	private String displayName = null;
	@XmlAttribute
	private String displayDescription = null;
	@XmlAttribute
	private String loinc = "";
    @XmlAttribute
    private Boolean graphable = true;

	public String getTestname() {
		return testname;
	}

	public void setTestname(String testname) {
		this.testname = testname;
	}

	public Date getResultedDate() {
		return resultedDate;
	}

	public void setResultedDate(Date resultedDate) {
		this.resultedDate = resultedDate;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;

        determineGraphable();
	}

	public String getValueUnits() {
		return valueUnits;
	}

	public void setValueUnits(String valueUnits) {
		this.valueUnits = valueUnits;
	}

	public String getReferenceHigh() {
		return referenceHigh;
	}

	public void setReferenceHigh(String referenceHigh) {
		this.referenceHigh = referenceHigh;
	}

	public String getReferenceLow() {
		return referenceLow;
	}

	public void setReferenceLow(String referenceLow) {
		this.referenceLow = referenceLow;
	}

	public String getIndicator() {
		return indicator;
	}

	public void setIndicator(String indicator) {
		this.indicator = indicator;
	}

	public String getAccessionNumber() {
		return accessionNumber;
	}

	public void setAccessionNumber(String accessionNumber) {
		this.accessionNumber = accessionNumber;
	}

	public String getTestId() {
		return this.testId;
	}

	public void setTestId(String testId) {
		this.testId = testId;
	}
	
	public String getGroupingId() {
		if (NullChecker.isNotNullish(getLoinc()))
			return getLoinc();
		else if (NullChecker.isNotNullish(getTestId()) && NullChecker.isNotNullish(getSpecimenName()))
			return getTestId() + "-" + getSpecimenName();

		return testname;
	}

	public String getLabType() {
		return labtype;
	}

	public void setLabType(String type) {
		this.labtype = type;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public String getComment() {
		return comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public void setOrderId(String orderId) {
		this.orderId = orderId;
	}

	public String getOrderId() {
		return orderId;
	}

	public void setAbnormalIndicatorFlag(boolean abnormalIndicatorFlag) {
		this.abnormalIndicatorFlag = abnormalIndicatorFlag;
	}

	public boolean isAbnormalIndicatorFlag() {
		return abnormalIndicatorFlag;
	}

	public void setSpecimenId(String specimen) {
		this.specimenId = specimen;
	}

	public String getSpecimenId() {
		return specimenId;
	}

	public String getSpecimenName() {
		return specimenName;
	}

	public void setSpecimenName(String specimenName) {
		this.specimenName = specimenName;
	}

	public void setAbnormalIndicatorTriFlag(TriState abnormalIndicatorTriFlag) {
		this.abnormalIndicatorTriFlag = abnormalIndicatorTriFlag;
	}

	public TriState getAbnormalIndicatorTriFlag() {
		return abnormalIndicatorTriFlag;
	}

	public String getDisplayName() {
		return displayName;
	}

	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	public String getDisplayDescription() {
		return displayDescription;
	}

	public void setDisplayDescription(String displayDescription) {
		this.displayDescription = displayDescription;
	}
	
	public String getLabtype() {
		return labtype;
	}

	public void setLabtype(String labtype) {
		this.labtype = labtype;
	}

	public String getLoinc() {
		return loinc;
	}

	public void setLoinc(String loinc) {
		this.loinc = loinc;
	}

    public Boolean isGraphable() {
        return graphable;
    }

    public void setGraphable(Boolean _graphable) {
        this.graphable = _graphable;
    }

	@Override
	public Date getDate() {
		return getResultedDate();
	}

	@Override
	public int compareTo(LabResult that) {
		return this.getResultedDate().compareTo(that.getResultedDate()) * -1;
	}

    private void determineGraphable() {
        boolean canGraph = true;
        try {
             Double.parseDouble(getValue());
        } catch(NumberFormatException formatEx) {
            canGraph = false;
        } catch (NullPointerException npe) {
            canGraph = false;
        }

        setGraphable(canGraph);
    }
}
