package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "healthAdvocateRequestEligibility", namespace = Namespace.MobileHealthPlatform)
public class HealthAdvocateRequestEligibility extends PatientData {

	private static final long serialVersionUID = -3883435566745032401L;

	@XmlElement
	private boolean eligible;
	@XmlElement
	private String message;
	
	public HealthAdvocateRequestEligibility() {
		
	}
	
	public HealthAdvocateRequestEligibility(PatientIdentifier patientIdentifier) {
		this.setPatientIdentifier(patientIdentifier);
	}

	public boolean isEligible() {
		return eligible;
	}

	public void setEligible(boolean eligible) {
		this.eligible = eligible;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	
	
}
