package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;
import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "healthAdvocate", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class HealthAdvocateRequest extends PatientData {

	private static final long serialVersionUID = 860638014372926554L;

	@XmlElement
	private String healthAdvocateEDIPI;
	@XmlElement
	private String patientName;
	@XmlElement
	private String patientDisplayName;
	@XmlElement
	private String uriLinkKey;
	@XmlElement
	private String email;
	@XmlElement
	private String firstName;
	@XmlElement
	private String lastName;
	@XmlElement
	private String addressFirstLine;
	@XmlElement
	private String addressSecondLine;
	@XmlElement
	private String city;
	@XmlElement
	private String state;
	@XmlElement
	private String zipCode;
	@XmlElement
	private String status;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date requestDate;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date lastActionDate;
	@XmlElement
	private String driversLicenseNumber;
	@XmlElement
	private String driversLicenseState;
	@XmlElement
	private String ssn;

	public String getHealthAdvocateEDIPI() {
		return healthAdvocateEDIPI;
	}

	public void setHealthAdvocateEDIPI(String healthAdvocateEDIPI) {
		this.healthAdvocateEDIPI = healthAdvocateEDIPI;
	}

	public String getUriLinkKey() {
		return uriLinkKey;
	}

	public void setUriLinkKey(String uriLinkKey) {
		this.uriLinkKey = uriLinkKey;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getAddressFirstLine() {
		return addressFirstLine;
	}

	public void setAddressFirstLine(String address) {
		this.addressFirstLine = address;
	}

	public String getAddressSecondLine() {
		return addressSecondLine;
	}

	public void setAddressSecondLine(String addressSecondLine) {
		this.addressSecondLine = addressSecondLine;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getZipCode() {
		return zipCode;
	}

	public void setZipCode(String zipCode) {
		this.zipCode = zipCode;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Date getRequestDate() {
		return requestDate;
	}

	public void setRequestDate(Date requestDate) {
		this.requestDate = requestDate;
	}

	public void setFormDetailUri(URI healthAdvocateRequestDetailUri) {
		getLink().addRelatedLink(LinkTitles.HealthAdvocateRequestFormDetail, healthAdvocateRequestDetailUri);
	}

	public AtomLink getFormDetailUri() {
		return getLink().getLinkByTitle(LinkTitles.HealthAdvocateRequestFormDetail);

	}

	public Date getLastActionDate() {
		return lastActionDate;
	}

	public void setLastActionDate(Date lastActionDate) {
		this.lastActionDate = lastActionDate;
	}

	public String getPatientName() {
		return patientName;
	}

	public void setPatientName(String patientName) {
		this.patientName = patientName;
	}

	public String getDriversLicenseNumber() {
		return this.driversLicenseNumber;
	}

	public void setDriversLicenseNumber(String licenseNumber) {
		this.driversLicenseNumber = licenseNumber;
	}

	public String getDriversLicenseState() {
		return this.driversLicenseState;
	}

	public void setDriversLicenseState(String state) {
		this.driversLicenseState = state;
	}

	public String getPatientDisplayName() {
		return patientDisplayName;
	}

	public void setPatientDisplayName(String patientDisplayName) {
		this.patientDisplayName = patientDisplayName;
	}

	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("Status: ");
		sb.append(this.status);
		sb.append(" Last Action Date: ");
		sb.append(this.lastActionDate);

		return sb.toString();
	}

	public String getSsn() {
		return ssn;
	}

	public void setSsn(String ssn) {
		this.ssn = ssn;
	}

}
