package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "dataSeries", namespace = Namespace.MobileHealthPlatform)
public class GraphDataSeries extends DomainTransferObjectCollection<GraphItem> {

	private static final long serialVersionUID = -9009979639241202358L;
	@XmlElement
	private Double referenceLow;
	@XmlElement
	private Double referenceHigh;
	@XmlElement
	private Double reference;
	@XmlElement
	private double maxX;
	@XmlElement
	private double maxY;
	@XmlElement
	private double minX;
	@XmlElement
	private double minY;
	@XmlElement
	private String title;

	public double getMaxX() {
		return maxX;
	}

	public void setMaxX(double maxX) {
		this.maxX = maxX;
	}

	public double getMaxY() {
		return maxY;
	}

	public void setMaxY(double maxY) {
		this.maxY = maxY;
	}

	public double getMinX() {
		return minX;
	}

	public void setMinX(double minX) {
		this.minX = minX;
	}

	public double getMinY() {
		return minY;
	}

	public void setMinY(double minY) {
		this.minY = minY;
	}

	public static long getSerialversionuid() {
		return serialVersionUID;
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<GraphItem> getItem() {
		return this;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public Double getReferenceLow() {
		return referenceLow;
	}

	public void setReferenceLow(double referenceLow) {
		this.referenceLow = referenceLow;
	}

	public Double getReferenceHigh() {
		return referenceHigh;
	}

	public void setReferenceHigh(double referenceHigh) {
		this.referenceHigh = referenceHigh;
	}

	public Double getReference() {
		return reference;
	}

	public void setReference(double reference) {
		this.reference = reference;
	}

}
