package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;

/**
*
* @author j.ray
*/
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.MobileHealthPlatform)
public class DomainTransferObject implements Serializable, ObjectTypeable {

	private static final long serialVersionUID = -8548209290509175328L;
	private AtomLinks links = null;

	@XmlElement(name = "link", namespace = Namespace.Atom)
	public AtomLinks getLink() {
		if (this.links == null) {
			this.links = new AtomLinks();
		}

		return this.links;
	}
	
	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}

	public AtomLink getSelfLink() {
		return getLink().getSelfLink();
	}

	public URI getSelfUri() {
		AtomLink link = getSelfLink();
		return AtomLink.extractUri(link);
	}

	public void setSelfUri(URI uri) {
		AtomLink link = new AtomLink();
		link.setHref(uri);
		link.setRel(rel.self);
		getLink().setSelfLink(link);
	}

}
