package com.agilex.healthcare.mobilehealthplatform.domain;

import java.net.URI;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;

@Entity
@Table(name="DOCUMENT_BODY")
@XmlRootElement(name = "document-body")
@XmlAccessorType(value = XmlAccessType.NONE)
public class DocumentBody extends PatientData  {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private byte[] contents = null;
    
	@XmlAttribute
	private String mimeType=null;
    
    @XmlAttribute
    private URI uri = null;
    
    private Document document;

    public DocumentBody() {
    }
    
    @Id
    @GeneratedValue
    @Column(name="DOCUMENT_BODY_ID")
    public String getId() {
    	return this.getDataIdentifier().getUniqueId();
    }
    
    public void setId(String id) {
    	this.getDataIdentifier().setUniqueId(id);
    }

    @Lob
    @Column(name="CONTENTS")
    public byte[] getContents() {
        return contents;
    }

    public void setContents(byte[] contents) {
        this.contents = contents;
    }

    public void setUribyParentDocument(Document d) {
        //this.setURI(UriHelper.mergeUri(d, "body"));
    }

    @Column(name="MIME_TYPE")
    public String getMimeType() {
        return mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Transient
    public URI getUri() {
        return uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @ManyToOne
    @JoinColumn(name="DOCUMENT_ID")
	public Document getDocument() {
		return document;
	}

	public void setDocument(Document document) {
		this.document = document;
	}
    
    
}
