package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.*;

@XmlRootElement(name = "document", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class Document extends PatientData {

	private static final long serialVersionUID = -7029754557679726640L;

	@XmlAttribute
	private String documentTitle = "";

	@XmlAttribute
	private String classCode = "";
	
	@XmlElement
	private String mimeType;

	@XmlElement
	private DocumentBody body = new DocumentBody();

	@XmlElement
	private RelatedDataItem parentData = null;

	public Document() {
	}

	public Document(String documentUniqueId) {
		this.setUniqueId(documentUniqueId);
	}

	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	public DocumentBody getBody() {
		if (body == null)
			body = new DocumentBody();
		return body;
	}

	public void setBody(DocumentBody body) {
		this.body = body;
	}

	public String getDocumentTitle() {
		return documentTitle;
	}

	public void setDocumentTitle(String documentTitle) {
		this.documentTitle = documentTitle;
	}

	public String getClassCode() {
		return classCode;
	}

	public void setClassCode(String classCode) {
		this.classCode = classCode;
	}

	public String getPatientId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	public void setPatientId(String patientId) {
		this.getPatientIdentifier().setUniqueId(patientId);
	}

	public RelatedDataItem getParentData() {
		return parentData;
	}

	public void setParentData(RelatedDataItem parentData) {
		this.parentData = parentData;
	}

	public String getMimeType() {
		return mimeType;
	}

	public void setMimeType(String mimeType) {
		this.mimeType = mimeType;
	}

}
