package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.MealType;
import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@Entity
@Table(name = "DIET_ENTRY")
@XmlRootElement(name = "mealEntry", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DietEntry extends PatientData implements Dateable {

	private static final long serialVersionUID = 7107581483910955021L;

	@XmlElement
	private MealType mealType;
	@XmlElement
	private String notes;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryDate;
	@XmlElement
	private String calories;
	@XmlElement
	private String fat;
	@XmlElement
	private String carbs;
	@XmlElement
	private String protein;

	@Id
	@GeneratedValue
	@Column(name = "DIET_ENTRY_ID")
	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	@Override
	@Column(name = "PATIENT_ID")
	public String getPatientId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	@Override
	public void setPatientId(String patientId) {
		this.getPatientIdentifier().setUniqueId(patientId);
	}

	@Column(name = "MEAL_TYPE")
	@Enumerated(EnumType.STRING)
	public MealType getMealType() {
		return mealType;
	}

	public void setMealType(MealType mealType) {
		this.mealType = mealType;
	}

	@Column(name = "NOTES")
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	@Column(name = "ENTRY_DATE")
	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	@Column(name = "CALORIES")
	public String getCalories() {
		return calories;
	}

	public void setCalories(String calories) {
		this.calories = calories;
	}

	@Column(name = "FAT")
	public String getFat() {
		return fat;
	}

	public void setFat(String fat) {
		this.fat = fat;
	}

	@Column(name = "CARBS")
	public String getCarbs() {
		return carbs;
	}

	public void setCarbs(String carbs) {
		this.carbs = carbs;
	}

	@Column(name = "PROTEIN")
	public String getProtein() {
		return protein;
	}

	public void setProtein(String protein) {
		this.protein = protein;
	}

	@Override
	@Transient
	public Date getDate() {
		return getEntryDate();
	}

}
