package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.persistence.Column;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;


@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "deviceRegistration", namespace = Namespace.MobileHealthPlatform)
public class DeviceRegistration extends PatientData {

	private static final long serialVersionUID = -3126648829212936744L;

	@XmlAttribute
	private String deviceToken;

	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date registeredDate;
	
	@XmlAttribute
	private boolean optedIn = true;

	@XmlTransient
	private String firstName;

	@XmlTransient
	private String lastName;

	public DeviceRegistration() {
	}

	public DeviceRegistration(String userId, String deviceToken) {
		setUserId(userId);
		setDeviceToken(deviceToken);
	}

	public DeviceRegistration(String userId, String deviceToken, String firstName, String lastName) {
		this(userId, deviceToken);
		setFirstName(firstName);
		setLastName(lastName);
	}


	public String getDeviceRegistrationId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setDeviceRegistrationId(String deviceRegistrationId) {
		this.getDataIdentifier().setUniqueId(deviceRegistrationId);
	}

	@XmlAttribute
	@Column(name = "USER_ID")
	public String getUserId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	public void setUserId(String userId) {
		this.getPatientIdentifier().setUniqueId(userId);
	}

	public Date getRegisteredDate() {
		return registeredDate;
	}

	public void setRegisteredDate(Date registeredDate) {
		this.registeredDate = registeredDate;
	}

	public String getDeviceToken() {
		return deviceToken;
	}

	public void setDeviceToken(String deviceToken) {
		this.deviceToken = deviceToken;
	}

	public String getFirstName() {
		return firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public boolean isOptedIn() {
		return optedIn;
	}

	public void setOptedIn(boolean optedIn) {
		this.optedIn = optedIn;
	}


	
	
}
