package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlRootElement(name = "dailyEvent", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class DailyEvent extends PatientData implements Dateable {

	private static final long serialVersionUID = 7538547403039879517L;
	
	@XmlElement
	private String notes;
	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	private Date entryDate;
	@XmlElement
	private String title;
	
	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	@Override
	public String getPatientId() {
		return this.getPatientIdentifier().getUniqueId();
	}

	@Override
	public void setPatientId(String patientId) {
		this.getPatientIdentifier().setUniqueId(patientId);
	}
	
	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}
	
	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}
	
	public Date getEntryDate() {
		return entryDate;
	}

	public void setEntryDate(Date entryDate) {
		this.entryDate = entryDate;
	}

	@Override
	public Date getDate() {
		return getEntryDate();
	}
}
