package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "customView", namespace = Namespace.MobileHealthPlatform)
public class CustomView extends PatientData {

	private static final long serialVersionUID = 8016641643422639015L;

	private static final String LATEST = "latest";
	private static final String REPORT = "report";
	
	@XmlElement
	private String customViewName;
	
	public String getCustomViewName() {
		return customViewName;
	}

	public void setCustomViewName(String customViewName) {
		this.customViewName = customViewName;
	}

	@XmlElement
	public String getUri(){
		if(this.getSelfUri() != null){
			return getSelfUri().toString();
		}else{
			return null;
		}
	}

	@XmlElement
	public String getLatestUri() {
		return getUriByTitle(LATEST);
	}

	@XmlElement
	public String getReportUri() {
		return getUriByTitle(REPORT);
	}
	
	private String getUriByTitle(String title){
		AtomLink link = getLink().getLinkByTitle(title);
		if (link != null) {
			return link.getHref().toString();
		} else {
			return null;
		}
	}	
	
	
}
