package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;


@XmlRootElement(name = "contactLog", namespace = Namespace.MobileHealthPlatform)
@XmlAccessorType(value = XmlAccessType.NONE)
public class ContactLog extends PatientData implements Dateable {

	private static final long serialVersionUID = -7352776331202851378L;

	@XmlElement
	String activity;

	@XmlElement
	String task;

	@XmlElement
	String contact;

	@XmlElement
	String note;

	@XmlElement
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	Date logTime;

	public String getId() {
		return this.getDataIdentifier().getUniqueId();
	}

	public void setId(String id) {
		this.getDataIdentifier().setUniqueId(id);
	}

	public String getActivity() {
		return activity;
	}

	public void setActivity(String activity) {
		this.activity = activity;
	}

	public String getTask() {
		return task;
	}

	public void setTask(String task) {
		this.task = task;
	}

	public String getContact() {
		return contact;
	}

	public void setContact(String contact) {
		this.contact = contact;
	}

	public String getNote() {
		return note;
	}

	public void setNote(String note) {
		this.note = note;
	}

	public Date getLogTime() {
		return logTime;
	}

	public void setLogTime(Date logTime) {
		this.logTime = logTime;
	}

	@Override
	public Date getDate() {
		return getLogTime();
	}

}
