package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlType(propOrder={"elementTypes","pastAppointments","hospitalizations"})
@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "clinic-events", namespace = Namespace.MobileHealthPlatform)
public class ClinicEvents {
	private ElementTypes elementTypes;
	private Appointments pastAppointments;
	private Admissions hospitalizations;
	
	public ClinicEvents() {
		ElementTypes types = new ElementTypes();
		types.add("Past-Appointments");
		types.add("Hospitalizations");
		
		elementTypes = types;
	}
	
	@XmlElement(name="elementTypes", namespace = Namespace.MobileHealthPlatform)
	public ElementTypes getElementTypes() {
		return elementTypes;
	}
	
	@XmlElement(name="Past-Appointments", namespace = Namespace.MobileHealthPlatform)
	public Appointments getPastAppointments() {
		return pastAppointments;
	}

	@XmlElement(name="Hospitalizations", namespace = Namespace.MobileHealthPlatform)
	public Admissions getHospitalizations() {
		return hospitalizations;
	}
	
	public void setPastAppointments(Appointments pastAppointments) {
		Appointments appointments = new Appointments();
		
		for (Appointment pastAppointment : pastAppointments) {
			appointments.add(pastAppointment);
		}
		
		this.pastAppointments = appointments;
	}
	
	public void setHospitalizations(Admissions hospitalizations) {
		Admissions admissions = new Admissions();
		
		for (Admission hospitalization : hospitalizations) {
			admissions.add(hospitalization);
		}
		
		this.hospitalizations = admissions;
	}
}
