package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "calendarEvents", namespace = Namespace.MobileHealthPlatform)
public class CalendarEvents extends PatientDataCollection<CalendarEvent> {

	private static final long serialVersionUID = 2390676474350057726L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<CalendarEvent> getCalendarEvent() {
		return this;
	}

	public void addAll(Appointments appointments) {
		for (Appointment appointment : appointments) {
			CalendarEvent calendarEvent = CalendarEvent.fromAppointment(appointment);
			this.add(calendarEvent);
		}
	}
}
