package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "calendarEvent", namespace = Namespace.MobileHealthPlatform)
public class CalendarEvent extends PatientData {

	private static final long serialVersionUID = -4279386965345393311L;

	private int DEFAULT_ALERT_DURATION = 15;

	@XmlAttribute
	private String title;
	@XmlAttribute
	private String notes;
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date startDate;
	@XmlAttribute
	private Integer duration = 0;
	@XmlAttribute
	private Integer alertDuration = DEFAULT_ALERT_DURATION;

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public Date getStartDate() {
		return startDate;
	}

	public Integer getDuration() {
		return duration;
	}

	public void setDuration(Integer duration) {
		this.duration = duration;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Integer getAlertDuration() {
		return alertDuration;
	}

	public void setAlertDuration(Integer alertDuration) {
		this.alertDuration = alertDuration;
	}

	public static CalendarEvent fromAppointment(Appointment appointment) {
		CalendarEvent calendarEvent = new CalendarEvent();
		calendarEvent.setTitle("patient appointment");
		calendarEvent.setDataIdentifier(appointment.getDataIdentifier());
		calendarEvent.setPatientIdentifier(appointment.getPatientIdentifier());
		calendarEvent.setDuration(appointment.getAppointmentDuration());
		calendarEvent.setStartDate(appointment.getAppointmentStartDate());
		return calendarEvent;
	}

}
