package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "auditLogs", namespace = Namespace.MobileHealthPlatform)
public class AuditLogs extends DomainTransferObjectCollection<AuditLog> {
	
	private static final long serialVersionUID = 1310993343761458471L;
	
	public AuditLogs() {}
	
	public AuditLogs(List<AuditLog> auditLogList) {
		this.addAll(auditLogList);
	}
	
	public AuditLogs(AuditLog...auditLogs) {
		for(int i = 0; i < auditLogs.length; i++) {
			this.add(auditLogs[i]);
		}
	}

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<AuditLog> getAuditLog() {
		return this;
	}

}
