package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshallerNoNulls;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "auditLog", namespace = Namespace.MobileHealthPlatform)
public class AuditLog extends DomainTransferObject implements Dateable {

	private static final long serialVersionUID = 3744887216336955744L;
	@XmlAttribute
	private String id;
	@XmlAttribute
	private String userId = "";
	@XmlAttribute
	private String type = "";
	@XmlAttribute
	private String subType = "";
	@XmlAttribute
	@XmlJavaTypeAdapter(DateTimeMarshallerNoNulls.class)
	private Date date = null;
	@XmlAttribute
	private String details = "";

	public AuditLog() {
	}

	public AuditLog(String userId, String type, String subType, Date date, String details) {
		this.userId = userId;
		this.type = type;
		this.subType = subType;
		this.date = date;
		this.details = details;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getSubType() {
		return subType;
	}

	public void setSubType(String subType) {
		this.subType = subType;
	}

	public Date getDate() {
		return date;
	}

	public void setDate(Date date) {
		this.date = date;
	}

	public String getDetails() {
		return details;
	}

	public void setDetails(String details) {
		this.details = details;
	}
}
