package com.agilex.healthcare.mobilehealthplatform.domain;

import java.io.Serializable;
import java.net.URI;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * 
 * @author j.ray
 */
@XmlRootElement(name = "link", namespace = Namespace.Atom)
@XmlAccessorType(value = XmlAccessType.NONE)
public class AtomLink implements Serializable, ObjectTypeable {

	private static final long serialVersionUID = 2572979173002553027L;

	@XmlAttribute(name = "rel")
	private String rel = null;
	@XmlAttribute(name = "title")
	private String title = null;
	@XmlAttribute(name = "href")
	private URI href = null;
	@XmlAttribute(name = "type")
	private String type = null;
	@XmlAttribute(name = "hreflang")
	private String hreflang = null;
	@XmlAttribute(name = "length")
	private String length = null;

	public URI getHref() {
		return href;
	}

	public void setHref(URI href) {
		this.href = href;
	}

	public String getRel() {
		return rel;
	}

	public void setRel(String rel) {
		this.rel = rel;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getHreflang() {
		return hreflang;
	}

	public void setHreflang(String hreflang) {
		this.hreflang = hreflang;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getLength() {
		return length;
	}

	public void setLength(String length) {
		this.length = length;
	}

	static public URI extractUri(AtomLink link) {
		URI uri = null;
		if (link != null) {
			uri = link.href;
		}
		return uri;
	}

	@XmlElement(name = "object-type")
	public String getObjectType() {
		return this.getClass().getSimpleName();
	}
	
	@Override
	public String toString() {
		return getTitle() + " : " + getHref().toString();
	}
}
