package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;


@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessments", namespace = Namespace.MobileHealthPlatform)
public class Assessments extends DomainTransferObjectCollection<Assessment> {


	private static final long serialVersionUID = 2845511765250045793L;

	@XmlElement(namespace=Namespace.MobileHealthPlatform)
	public Collection<Assessment> getAssessment() {
		return this;
	}

	public Assessment getAssessmentById(String assessmentId) {
		for (Assessment assessmentToCompare : this) {
			if (assessmentToCompare.getId().equals(assessmentId)) {
				return assessmentToCompare;
			}
		}
		return null;
	}
}
