package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Collection;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessmentResults", namespace = Namespace.MobileHealthPlatform)
public class AssessmentResults extends PatientDataCollection<AssessmentResult> {
	private static final long serialVersionUID = 6310911978132811036L;

	@XmlElement(namespace = Namespace.MobileHealthPlatform)
	public Collection<AssessmentResult> getAssessmentResult() {
		return this;
	}

	public AssessmentResult getAssessmentResultById(String uniqueId) {
		for (AssessmentResult resultToCompare : this) {
			if (resultToCompare.getUniqueId().equals(uniqueId)) {
				return resultToCompare;
			}
		}
		return null;
	}

	public AssessmentResult getResultByAssessmentId(String assessmentId) {
		for (AssessmentResult resultToCompare : this) {
			String resultToCompareAssessmentId = resultToCompare.getAssessmentId();
			if (resultToCompareAssessmentId != null) {
				if (resultToCompareAssessmentId.equals(assessmentId)) {
					return resultToCompare;
				}
			}
		}
		return null;
	}
}
