package com.agilex.healthcare.mobilehealthplatform.domain;

import java.util.Date;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

import com.agilex.healthcare.utility.datemarshallers.DateTimeMarshaller;

@XmlAccessorType(XmlAccessType.NONE)
@XmlRootElement(name = "assessmentResult", namespace = Namespace.MobileHealthPlatform)
public class AssessmentResult extends PatientData implements Dateable {

	private static final long serialVersionUID = -2158569736972562853L;

	@XmlElement
	private String uniqueTitle;
	@XmlElement
	private String version;
	@XmlElement
	private String authenticationStrategy;
	@XmlElement
	private String notes;
	@XmlElement
	private String scoringAlgorithm;
	@XmlElement
	private String assessmentId;
	@XmlJavaTypeAdapter(DateTimeMarshaller.class)
	@XmlElement
	private Date dateTaken;
	@XmlElement
	private boolean inProgress;
	@XmlElement(name = "assessmentResponse")
	private AssessmentResponses assessmentResponse;
	@XmlElement(name = "assessmentResultScore")
	private AssessmentResultReport assessmentResultReport;
	@XmlElement
	private int waitingPeriod;
	@XmlElement
	private int score;

	public String getAssessmentId() {
		return assessmentId;
	}

	public void setAssessmentId(String assessmentId) {
		this.assessmentId = assessmentId;
	}

	public int getScore() {
		return score;
	}

	public void setScore(int score) {
		this.score = score;
	}

	public Date getDateTaken() {
		return dateTaken;
	}

	public void setDateTaken(Date dateTaken) {
		this.dateTaken = dateTaken;
	}

	public AssessmentResponses getResponses() {
		return assessmentResponse;
	}

	public void setResponses(AssessmentResponses responses) {
		this.assessmentResponse = responses;
	}

	public String getUniqueTitle() {
		return uniqueTitle;
	}

	public void setUniqueTitle(String uniqueTitle) {
		this.uniqueTitle = uniqueTitle;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public String getAuthenticationStrategy() {
		return authenticationStrategy;
	}

	public void setAuthenticationStrategy(String authenticationStrategy) {
		this.authenticationStrategy = authenticationStrategy;
	}

	public String getNotes() {
		return notes;
	}

	public void setNotes(String notes) {
		this.notes = notes;
	}

	public boolean isInProgress() {
		return inProgress;
	}

	public void setInProgress(boolean inProgress) {
		this.inProgress = inProgress;
	}

	public AssessmentResultReport getAssessmentResultReport() {
		return assessmentResultReport;
	}

	public void setAssessmentResultReport(AssessmentResultReport assessmentResultReport) {
		this.assessmentResultReport = assessmentResultReport;
	}

	public String getScoringAlgorithm() {
		return scoringAlgorithm;
	}

	public void setScoringAlgorithm(String scoringAlgorithm) {
		this.scoringAlgorithm = scoringAlgorithm;
	}

	@Override
	public Date getDate() {
		return this.dateTaken;
	}

	public void setWaitingPeriod(int waitingPeriod) {
		this.waitingPeriod = waitingPeriod;
	}

	public int getWaitingPeriod() {
		return waitingPeriod;
	}
}
