package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessmentQuestion", namespace = Namespace.MobileHealthPlatform)
public class AssessmentQuestion extends DomainTransferObject {

	private static final long serialVersionUID = -8873025232383643010L;

	@XmlElement
	private String id;
	@XmlElement
	private int questionNumber;
	@XmlElement
	private String type;
	@XmlElement
	private String prompt;
	@XmlElement(name = "questionChoice")
	private AssessmentQuestionChoices questionChoices = new AssessmentQuestionChoices();
	@XmlElement(name = "questionProperty")
	private AssessmentProperties questionProperties = new AssessmentProperties();

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getPrompt() {
		return prompt;
	}

	public void setPrompt(String prompt) {
		this.prompt = prompt;
	}

	public AssessmentQuestionChoices getQuestionChoices() {
		return questionChoices;
	}

	public void setQuestionChoices(AssessmentQuestionChoices questionChoices) {
		this.questionChoices = questionChoices;
	}

	public int getQuestionNumber() {
		return questionNumber;
	}

	public void setQuestionNumber(int questionNumber) {
		this.questionNumber = questionNumber;
	}

	public AssessmentProperties getQuestionProperties() {
		return questionProperties;
	}

	public void setQuestionProperties(AssessmentProperties questionProperties) {
		this.questionProperties = questionProperties;
	}
}
