package com.agilex.healthcare.mobilehealthplatform.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(name = "assessmentQuestionProperty", namespace = Namespace.MobileHealthPlatform)
public class AssessmentProperty extends DomainTransferObject {

	private static final long serialVersionUID = 5176382478627187929L;

	public static final String DISPLAY_TEXT = "displayText";
	
	@XmlElement
	private String name;	
	@XmlElement
	private String value;

	public AssessmentProperty() {		
	}
	
	public AssessmentProperty(String name, String value) {
		this.name = name;
		this.value = value;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}
